/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.GuiScreenTooltip;
import net.spellcraftgaming.rpghud.gui.GuiSettingsModColor;
import net.spellcraftgaming.rpghud.gui.TextFieldWidgetMod;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.SettingColor;
import net.spellcraftgaming.rpghud.settings.SettingDouble;
import net.spellcraftgaming.rpghud.settings.SettingPosition;
import net.spellcraftgaming.rpghud.settings.Settings;

@OnlyIn(value=Dist.CLIENT)
public class GuiSettingsMod
extends GuiScreenTooltip {
    private Settings settings;
    private Screen parent;
    private String subSetting;
    private Map<String, List<TextFieldWidget>> textFields = new HashMap<String, List<TextFieldWidget>>();
    private GuiSettingsMod instance;

    public GuiSettingsMod(Screen parent, String subSetting, ITextComponent titleIn) {
        super(titleIn);
        this.parent = parent;
        this.settings = ModRPGHud.instance.settings;
        this.subSetting = subSetting;
        this.instance = this;
    }

    public GuiSettingsMod(Screen parent, ITextComponent titleIn) {
        super(titleIn);
        this.parent = parent;
        this.settings = ModRPGHud.instance.settings;
        this.subSetting = "";
        this.instance = this;
    }

    public void init() {
        FontRenderer fontRenderer = this.minecraft.field_71466_p;
        if (this.subSetting.equals("")) {
            GuiButtonTooltip guismallbutton = new GuiButtonTooltip(this.width / 2 - 155 + 0, this.height / 6 - 14 + 0, "general", I18n.func_135052_a((String)"gui.rpg.general", (Object[])new Object[0]), button -> {
                GuiButtonTooltip b = (GuiButtonTooltip)button;
                if (b.enumOptions != null) {
                    this.minecraft.func_147108_a((Screen)new GuiSettingsMod(this.instance, b.enumOptions, (ITextComponent)new TranslationTextComponent("gui.settings.rpghud", new Object[0])));
                }
            }).setTooltip(I18n.func_135052_a((String)"tooltip.general", (Object[])new Object[0]));
            this.addButton((Widget)guismallbutton);
            int count = 1;
            for (HudElementType type : HudElementType.values()) {
                List<String> settings = this.settings.getSettingsOf(type);
                if (settings.isEmpty()) continue;
                guismallbutton = new GuiButtonTooltip(this.width / 2 - 155 + count % 2 * 160, this.height / 6 - 14 + 20 * (count >> 1), type.name(), I18n.func_135052_a((String)type.getDisplayName(), (Object[])new Object[0]), button -> {
                    GuiButtonTooltip b = (GuiButtonTooltip)button;
                    if (b.enumOptions != null) {
                        this.minecraft.func_147108_a((Screen)new GuiSettingsMod(this.instance, b.enumOptions, (ITextComponent)new TranslationTextComponent("gui.settings.rpghud", new Object[0])));
                    }
                }).setTooltip(I18n.func_135052_a((String)"tooltip.element", (Object[])new Object[0]));
                this.addButton((Widget)guismallbutton);
                ++count;
            }
        } else {
            List<String> settingList = this.settings.getSettingsOf(this.subSetting);
            for (int i = 0; i < settingList.size(); ++i) {
                if (this.settings.getSetting(settingList.get(i)) instanceof SettingPosition) {
                    String[] values = ((String)this.settings.getSetting(settingList.get(i)).getValue()).split("_");
                    ArrayList<TextFieldWidgetMod> fields = new ArrayList<TextFieldWidgetMod>();
                    GuiScreenTooltip.GuiTextLabel settingLabel = new GuiScreenTooltip.GuiTextLabel(this.width / 2 - 152 + i % 2 * 160, this.height / 6 - 8 + 20 * (i >> 1), this.settings.getButtonString(settingList.get(i)));
                    this.labelList.add(settingLabel);
                    TextFieldWidgetMod xPos = new TextFieldWidgetMod(fontRenderer, TextFieldWidgetMod.ValueType.POSITION, this.width / 2 - 100 + i % 2 * 160, this.height / 6 - 12 + 20 * (i >> 1), 45, 15, values[0]);
                    xPos.func_146180_a(values[0]);
                    xPos.func_146203_f(6);
                    this.children.add(xPos);
                    fields.add(xPos);
                    TextFieldWidgetMod yPos = new TextFieldWidgetMod(fontRenderer, TextFieldWidgetMod.ValueType.POSITION, this.width / 2 - 100 + i % 2 * 160 + 48, this.height / 6 - 12 + 20 * (i >> 1), 45, 15, values[1]);
                    yPos.func_146180_a(values[1]);
                    yPos.func_146203_f(6);
                    this.children.add(yPos);
                    fields.add(yPos);
                    this.textFields.put(settingList.get(i), fields);
                    continue;
                }
                if (this.settings.getSetting(settingList.get(i)) instanceof SettingDouble) {
                    ArrayList<TextFieldWidgetMod> fields = new ArrayList<TextFieldWidgetMod>();
                    GuiScreenTooltip.GuiTextLabel scaleLabel = new GuiScreenTooltip.GuiTextLabel(this.width / 2 - 151 + i % 2 * 160, this.height / 6 - 8 + 20 * (i >> 1), this.settings.getButtonString(settingList.get(i)));
                    TextFieldWidgetMod scale = new TextFieldWidgetMod(fontRenderer, TextFieldWidgetMod.ValueType.DOUBLE, this.width / 2 - 100 + i % 2 * 160 + 3, this.height / 6 - 12 + 20 * (i >> 1), 90, 15, String.valueOf(this.settings.getDoubleValue(settingList.get(i))));
                    scale.func_146180_a(String.valueOf(this.settings.getDoubleValue(settingList.get(i))));
                    this.labelList.add(scaleLabel);
                    this.children.add(scale);
                    fields.add(scale);
                    this.textFields.put(settingList.get(i), fields);
                    continue;
                }
                GuiButtonTooltip guismallbutton = new GuiButtonTooltip(this.width / 2 - 155 + i % 2 * 160, this.height / 6 - 14 + 20 * (i >> 1), settingList.get(i), this.settings.getButtonString(settingList.get(i)), button -> {
                    GuiButtonTooltip b = (GuiButtonTooltip)button;
                    if (b.enumOptions != null) {
                        if (this.settings.getSetting(b.enumOptions) instanceof SettingColor) {
                            this.minecraft.func_147108_a((Screen)new GuiSettingsModColor(this.instance, b.enumOptions, (ITextComponent)new TranslationTextComponent("gui.settings.rpghud", new Object[0])));
                        } else {
                            this.settings.increment(b.enumOptions);
                            button.setMessage(this.settings.getButtonString(b.enumOptions));
                        }
                    }
                }).setTooltip(this.settings.getSetting(settingList.get(i)).getTooltip());
                this.addButton((Widget)guismallbutton);
            }
        }
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 6 + 168, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            Settings settings = ModRPGHud.instance.settings;
            for (String settingID : this.textFields.keySet()) {
                for (TextFieldWidget t : this.textFields.get(settingID)) {
                    if (!(t instanceof TextFieldWidgetMod)) continue;
                    TextFieldWidgetMod.ValueType type = ((TextFieldWidgetMod)t).getValueType();
                    switch (type) {
                        case DOUBLE: {
                            try {
                                double value = Double.valueOf(this.textFields.get(settingID).get(0).func_146179_b());
                                this.settings.getSetting(settingID).setValue(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case POSITION: {
                            this.settings.getSetting(settingID).setValue(this.textFields.get(settingID).get(0).func_146179_b() + "_" + this.textFields.get(settingID).get(1).func_146179_b());
                        }
                    }
                }
            }
            settings.saveSettings();
            this.minecraft.func_147108_a(this.parent);
        }));
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.minecraft.field_71466_p, I18n.func_135052_a((String)"gui.rpg.settings", (Object[])new Object[0]), this.width / 2, 12, 0xFFFFFF);
        for (List<TextFieldWidget> positionPairs : this.textFields.values()) {
            for (TextFieldWidget t : positionPairs) {
                t.render(mouseX, mouseY, partialTicks);
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    public void tick() {
        super.tick();
        for (String settingID : this.textFields.keySet()) {
            for (TextFieldWidget t : this.textFields.get(settingID)) {
                if (t instanceof TextFieldWidgetMod) {
                    TextFieldWidgetMod.ValueType type = ((TextFieldWidgetMod)t).getValueType();
                    switch (type) {
                        case DOUBLE: {
                            try {
                                double value = Double.valueOf(this.textFields.get(settingID).get(0).func_146179_b());
                                this.settings.getSetting(settingID).setValue(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case POSITION: {
                            this.settings.getSetting(settingID).setValue(this.textFields.get(settingID).get(0).func_146179_b() + "_" + this.textFields.get(settingID).get(1).func_146179_b());
                        }
                    }
                }
                t.func_146178_a();
            }
        }
    }
}

